********************************************************************
****************DEBT AND CONSUMPTION - Full results*****************
*************************DATE: MAY 2019 ****************************
********************* AUTHOR: FIONA PRICE **************************
********************************************************************
clear
set more off
use "C:\UnbalancedHH_analytical NEW.dta", replace
sort hhid0 wave
replace hdebtt = . if hdebtt!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property

*************
**TABLE F1***
*************
mat TableF1 = J(27,9,.)
mat rown TableF1 = Debtcoeff Debtpv Inccoeff Incpv Hpcoeff Hppv Age2coeff Age2pv Age3coeff Age3pv Educ2coeff Educ2pv Educ3coeff Educ3pv kidscoeff kidspv adultcoeff adultpv marriedcoeff marriedpv unempcoeff unemppv nilfcoeff nilfpv const constpv Obs
mat coln TableF1 = NondurableOLS NondurableOLSFE NondurableIV DurableOLS DurableOLSFE DurableIV TotalOLS TotalOLSFE TotalIV

//set up list of control variables for model hp1t
local controlvars inct L.hp1t i.agewmax i.educ kids hhadult married unemp nilf 

//set up debt measure for model (hdebtt, hdebtinc, debtasset, mortinc)
local debtvar hdebtt

///1.  OLS Model no FE 
 reg consumpt L.`debtvar' `controlvars' if  L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  cluster(hhid0) robust
mat TableF1[1,7]=_b[L.`debtvar']
mat TableF1[2,7]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat TableF1[3,7]=_b[inct]
mat TableF1[4,7]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat TableF1[5,7]=_b[L.hp1t]
mat TableF1[6,7]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat TableF1[7,7]=_b[2.agewmax]
mat TableF1[8,7]=(2 * ttail(e(df_r), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,7]=_b[3.agewmax]
mat TableF1[10,7]=(2 * ttail(e(df_r), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,7]=_b[2.educ]
mat TableF1[12,7]=(2 * ttail(e(df_r), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,7]=_b[3.educ]
mat TableF1[14,7]=(2 * ttail(e(df_r), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,7]=_b[kids]
mat TableF1[16,7]=(2 * ttail(e(df_r), abs(_b[kids]/_se[kids])))
mat TableF1[17,7]=_b[hhadult]
mat TableF1[18,7]=(2 * ttail(e(df_r), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,7]=_b[married]
mat TableF1[20,7]=(2 * ttail(e(df_r), abs(_b[married]/_se[married])))
mat TableF1[21,7]=_b[unemp]
mat TableF1[22,7]=(2 * ttail(e(df_r), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,7]=_b[nilf]
mat TableF1[24,7]=(2 * ttail(e(df_r), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,7]=_b[_cons]
mat TableF1[26,7]=(2 * ttail(e(df_r), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,7]=e(N)

 reg expt L.`debtvar' `controlvars' if  L.`debtvar'>0 & tousend==1 & touse2==1 & touse3==1 & wave>=6 & wave<=17,  cluster(hhid0) robust
mat TableF1[1,1]=_b[L.`debtvar']
mat TableF1[2,1]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat TableF1[3,1]=_b[inct]
mat TableF1[4,1]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat TableF1[5,1]=_b[L.hp1t]
mat TableF1[6,1]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat TableF1[7,1]=_b[2.agewmax]
mat TableF1[8,1]=(2 * ttail(e(df_r), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,1]=_b[3.agewmax]
mat TableF1[10,1]=(2 * ttail(e(df_r), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,1]=_b[2.educ]
mat TableF1[12,1]=(2 * ttail(e(df_r), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,1]=_b[3.educ]
mat TableF1[14,1]=(2 * ttail(e(df_r), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,1]=_b[kids]
mat TableF1[16,1]=(2 * ttail(e(df_r), abs(_b[kids]/_se[kids])))
mat TableF1[17,1]=_b[hhadult]
mat TableF1[18,1]=(2 * ttail(e(df_r), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,1]=_b[married]
mat TableF1[20,1]=(2 * ttail(e(df_r), abs(_b[married]/_se[married])))
mat TableF1[21,1]=_b[unemp]
mat TableF1[22,1]=(2 * ttail(e(df_r), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,1]=_b[nilf]
mat TableF1[24,1]=(2 * ttail(e(df_r), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,1]=_b[_cons]
mat TableF1[26,1]=(2 * ttail(e(df_r), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,1]=e(N)

 reg durablet L.`debtvar' `controlvars' if L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  cluster(hhid0) robust
mat TableF1[1,4]=_b[L.`debtvar']
mat TableF1[2,4]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat TableF1[3,4]=_b[inct]
mat TableF1[4,4]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat TableF1[5,4]=_b[L.hp1t]
mat TableF1[6,4]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat TableF1[7,4]=_b[2.agewmax]
mat TableF1[8,4]=(2 * ttail(e(df_r), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,4]=_b[3.agewmax]
mat TableF1[10,4]=(2 * ttail(e(df_r), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,4]=_b[2.educ]
mat TableF1[12,4]=(2 * ttail(e(df_r), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,4]=_b[3.educ]
mat TableF1[14,4]=(2 * ttail(e(df_r), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,4]=_b[kids]
mat TableF1[16,4]=(2 * ttail(e(df_r), abs(_b[kids]/_se[kids])))
mat TableF1[17,4]=_b[hhadult]
mat TableF1[18,4]=(2 * ttail(e(df_r), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,4]=_b[married]
mat TableF1[20,4]=(2 * ttail(e(df_r), abs(_b[married]/_se[married])))
mat TableF1[21,4]=_b[unemp]
mat TableF1[22,4]=(2 * ttail(e(df_r), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,4]=_b[nilf]
mat TableF1[24,4]=(2 * ttail(e(df_r), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,4]=_b[_cons]
mat TableF1[26,4]=(2 * ttail(e(df_r), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,4]=e(N)

matlist TableF1

///2.  OLS Model with HH FE 
 xtreg consumpt `controlvars' L.`debtvar'  if L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1  & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat TableF1[1,8]=_b[L.`debtvar']
mat TableF1[2,8]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat TableF1[3,8]=_b[inct]
mat TableF1[4,8]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat TableF1[5,8]=_b[L.hp1t]
mat TableF1[6,8]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat TableF1[7,8]=_b[2.agewmax]
mat TableF1[8,8]=(2 * ttail(e(df_r), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,8]=_b[3.agewmax]
mat TableF1[10,8]=(2 * ttail(e(df_r), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,8]=_b[2.educ]
mat TableF1[12,8]=(2 * ttail(e(df_r), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,8]=_b[3.educ]
mat TableF1[14,8]=(2 * ttail(e(df_r), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,8]=_b[kids]
mat TableF1[16,8]=(2 * ttail(e(df_r), abs(_b[kids]/_se[kids])))
mat TableF1[17,8]=_b[hhadult]
mat TableF1[18,8]=(2 * ttail(e(df_r), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,8]=_b[married]
mat TableF1[20,8]=(2 * ttail(e(df_r), abs(_b[married]/_se[married])))
mat TableF1[21,8]=_b[unemp]
mat TableF1[22,8]=(2 * ttail(e(df_r), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,8]=_b[nilf]
mat TableF1[24,8]=(2 * ttail(e(df_r), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,8]=_b[_cons]
mat TableF1[26,8]=(2 * ttail(e(df_r), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,8]=e(N)
 xtreg expt `controlvars' L.`debtvar' if  L.`debtvar'>0 & tousend==1 & touse2==1 & touse3==1 & wave>=6 & wave<=17,  fe cluster(hhid0) robust
mat TableF1[1,2]=_b[L.`debtvar']
mat TableF1[2,2]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat TableF1[3,2]=_b[inct]
mat TableF1[4,2]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat TableF1[5,2]=_b[L.hp1t]
mat TableF1[6,2]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat TableF1[7,2]=_b[2.agewmax]
mat TableF1[8,2]=(2 * ttail(e(df_r), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,2]=_b[3.agewmax]
mat TableF1[10,2]=(2 * ttail(e(df_r), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,2]=_b[2.educ]
mat TableF1[12,2]=(2 * ttail(e(df_r), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,2]=_b[3.educ]
mat TableF1[14,2]=(2 * ttail(e(df_r), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,2]=_b[kids]
mat TableF1[16,2]=(2 * ttail(e(df_r), abs(_b[kids]/_se[kids])))
mat TableF1[17,2]=_b[hhadult]
mat TableF1[18,2]=(2 * ttail(e(df_r), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,2]=_b[married]
mat TableF1[20,2]=(2 * ttail(e(df_r), abs(_b[married]/_se[married])))
mat TableF1[21,2]=_b[unemp]
mat TableF1[22,2]=(2 * ttail(e(df_r), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,2]=_b[nilf]
mat TableF1[24,2]=(2 * ttail(e(df_r), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,2]=_b[_cons]
mat TableF1[26,2]=(2 * ttail(e(df_r), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,2]=e(N)
 xtreg durablet `controlvars' L.`debtvar' if   L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat TableF1[1,5]=_b[L.`debtvar']
mat TableF1[2,5]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat TableF1[3,5]=_b[inct]
mat TableF1[4,5]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat TableF1[5,5]=_b[L.hp1t]
mat TableF1[6,5]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat TableF1[7,5]=_b[2.agewmax]
mat TableF1[8,5]=(2 * ttail(e(df_r), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,5]=_b[3.agewmax]
mat TableF1[10,5]=(2 * ttail(e(df_r), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,5]=_b[2.educ]
mat TableF1[12,5]=(2 * ttail(e(df_r), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,5]=_b[3.educ]
mat TableF1[14,5]=(2 * ttail(e(df_r), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,5]=_b[kids]
mat TableF1[16,5]=(2 * ttail(e(df_r), abs(_b[kids]/_se[kids])))
mat TableF1[17,5]=_b[hhadult]
mat TableF1[18,5]=(2 * ttail(e(df_r), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,5]=_b[married]
mat TableF1[20,5]=(2 * ttail(e(df_r), abs(_b[married]/_se[married])))
mat TableF1[21,5]=_b[unemp]
mat TableF1[22,5]=(2 * ttail(e(df_r), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,5]=_b[nilf]
mat TableF1[24,5]=(2 * ttail(e(df_r), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,5]=_b[_cons]
mat TableF1[26,5]=(2 * ttail(e(df_r), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,5]=e(N)

matlist TableF1

///3. IV with postcode FE
drop Lhdebtt 
gen L`debtvar'=L.`debtvar'
local controlvars inct Lhp1t i.agewmax i.educ kids hhadult married unemp nilf
*include Ldhdebtt for Andersen et al (2016) model
*including Lhequity if controlling for home equity rather than home value

** Change panel variable from household to postcode
xtset, clear
xtset postcode
 xtivreg consumpt `controlvars' (L`debtvar'  =  Lpostboom) if L`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10, fe first 
mat TableF1[1,9]=_b[L`debtvar']
mat TableF1[2,9]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat TableF1[3,9]=_b[inct]
mat TableF1[4,9]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat TableF1[5,9]=_b[Lhp1t]
mat TableF1[6,9]=(2 * ttail(e(df_rz), abs(_b[Lhp1t]/_se[Lhp1t])))
mat TableF1[7,9]=_b[2.agewmax]
mat TableF1[8,9]=(2 * ttail(e(df_rz), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,9]=_b[3.agewmax]
mat TableF1[10,9]=(2 * ttail(e(df_rz), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,9]=_b[2.educ]
mat TableF1[12,9]=(2 * ttail(e(df_rz), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,9]=_b[3.educ]
mat TableF1[14,9]=(2 * ttail(e(df_rz), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,9]=_b[kids]
mat TableF1[16,9]=(2 * ttail(e(df_rz), abs(_b[kids]/_se[kids])))
mat TableF1[17,9]=_b[hhadult]
mat TableF1[18,9]=(2 * ttail(e(df_rz), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,9]=_b[married]
mat TableF1[20,9]=(2 * ttail(e(df_rz), abs(_b[married]/_se[married])))
mat TableF1[21,9]=_b[unemp]
mat TableF1[22,9]=(2 * ttail(e(df_rz), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,9]=_b[nilf]
mat TableF1[24,9]=(2 * ttail(e(df_rz), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,9]=_b[_cons]
mat TableF1[26,9]=(2 * ttail(e(df_rz), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,9]=e(N)
 xtivreg expt `controlvars' (L`debtvar'  =  Lpostboom) if  L`debtvar'>0 &  tousend==1 & touse2==1 & touse3==1  & wave>=6 & wave<=17, fe  first
mat TableF1[1,3]=_b[L`debtvar']
mat TableF1[2,3]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat TableF1[3,3]=_b[inct]
mat TableF1[4,3]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat TableF1[5,3]=_b[Lhp1t]
mat TableF1[6,3]=(2 * ttail(e(df_rz), abs(_b[Lhp1t]/_se[Lhp1t])))
mat TableF1[7,3]=_b[2.agewmax]
mat TableF1[8,3]=(2 * ttail(e(df_rz), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,3]=_b[3.agewmax]
mat TableF1[10,3]=(2 * ttail(e(df_rz), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,3]=_b[2.educ]
mat TableF1[12,3]=(2 * ttail(e(df_rz), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,3]=_b[3.educ]
mat TableF1[14,3]=(2 * ttail(e(df_rz), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,3]=_b[kids]
mat TableF1[16,3]=(2 * ttail(e(df_rz), abs(_b[kids]/_se[kids])))
mat TableF1[17,3]=_b[hhadult]
mat TableF1[18,3]=(2 * ttail(e(df_rz), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,3]=_b[married]
mat TableF1[20,3]=(2 * ttail(e(df_rz), abs(_b[married]/_se[married])))
mat TableF1[21,3]=_b[unemp]
mat TableF1[22,3]=(2 * ttail(e(df_rz), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,3]=_b[nilf]
mat TableF1[24,3]=(2 * ttail(e(df_rz), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,3]=_b[_cons]
mat TableF1[26,3]=(2 * ttail(e(df_rz), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,3]=e(N)

 xtivreg durablet `controlvars' (L`debtvar'  =  Lpostboom) if L`debtvar'>0 &  touse==1 & touse2==1  & touse3==1 & wave>=6 & wave<=10, fe  first
mat TableF1[1,6]=_b[L`debtvar']
mat TableF1[2,6]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat TableF1[3,6]=_b[inct]
mat TableF1[4,6]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat TableF1[5,6]=_b[Lhp1t]
mat TableF1[6,6]=(2 * ttail(e(df_rz), abs(_b[Lhp1t]/_se[Lhp1t])))
mat TableF1[7,6]=_b[2.agewmax]
mat TableF1[8,6]=(2 * ttail(e(df_rz), abs(_b[2.agewmax]/_se[2.agewmax])))
mat TableF1[9,6]=_b[3.agewmax]
mat TableF1[10,6]=(2 * ttail(e(df_rz), abs(_b[3.agewmax]/_se[3.agewmax])))
mat TableF1[11,6]=_b[2.educ]
mat TableF1[12,6]=(2 * ttail(e(df_rz), abs(_b[2.educ]/_se[2.educ])))
mat TableF1[13,6]=_b[3.educ]
mat TableF1[14,6]=(2 * ttail(e(df_rz), abs(_b[3.educ]/_se[3.educ])))
mat TableF1[15,6]=_b[kids]
mat TableF1[16,6]=(2 * ttail(e(df_rz), abs(_b[kids]/_se[kids])))
mat TableF1[17,6]=_b[hhadult]
mat TableF1[18,6]=(2 * ttail(e(df_rz), abs(_b[hhadult]/_se[hhadult])))
mat TableF1[19,6]=_b[married]
mat TableF1[20,6]=(2 * ttail(e(df_rz), abs(_b[married]/_se[married])))
mat TableF1[21,6]=_b[unemp]
mat TableF1[22,6]=(2 * ttail(e(df_rz), abs(_b[unemp]/_se[unemp])))
mat TableF1[23,6]=_b[nilf]
mat TableF1[24,6]=(2 * ttail(e(df_rz), abs(_b[nilf]/_se[nilf])))
mat TableF1[25,6]=_b[_cons]
mat TableF1[26,6]=(2 * ttail(e(df_rz), abs(_b[_cons]/_se[_cons])))
mat TableF1[27,6]=e(N)
** Change panel variable back to household from postcode
xtset, clear
xtset hhid0 wave

/// show results for all models
matlist TableF1 
